/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores.ModeloValoresComprobanteCompra;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaComprobanteCompra
extends PaginaAsistente
implements VistaModelo<TransaccionCompra>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private TransaccionCompra modeloDatos;
    private ModeloValoresComprobanteCompra modeloValores;
    private ComboViewer cvSustento;
    private ComboViewer cvTipoComprobante;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtNumSerie;
    private Text txtNumAutorizacion;
    private Text txtEstabModif;
    private Text txtPuntoMod;
    private Text txtSerialMod;
    private Text txtAutModif;
    private Composite cComplemento;
    private ComboViewer cvCompModificado;

    public PaginaComprobanteCompra(boolean editando) {
        super(PaginaComprobanteCompra.class.getName(), "Detalle Exportaci\u00f3n", "Especifique la informaci\u00f3n correspondiente");
        this.setDescription("Especifique la informaci\u00f3n correspondiente al comprobante");
        this.setTitle("Comprobante de Venta");
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        int anio = Integer.parseInt(((Iva)this.modeloDatos.getPropietario()).getDatosDeclaracion().getAnio());
        int mes = Integer.parseInt(((Iva)this.modeloDatos.getPropietario()).getDatosDeclaracion().getMes());
        boolean esMicroEmpresa = ((Iva)this.modeloDatos.getPropietario()).getDatosDeclaracion().isEsMicroEmpresa();
        this.modeloValores = new ModeloValoresComprobanteCompra(anio, mes, esMicroEmpresa);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(TransaccionCompra modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void filtarSustentos() {
        this.modeloValores.filtarSustentos(this.modeloDatos.getProveedor().getTipoIdentificacion());
        this.cvSustento.refresh();
    }

    public void procesarModeloDatos() {
        if (this.editando) {
            this.filtarSustentos();
        }
        String codSustento = this.modeloDatos.getComprobanteCompra().getTipoSustento();
        ElementoNombreValor tipoSustento = this.modeloValores.obtenerTipoSustento(codSustento);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvSustento, (Object)tipoSustento);
        String codComprobante = this.modeloDatos.getComprobanteCompra().getTipoComprobante();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoComprobante, (Object)tipoComprobante);
        if (codComprobante != null && tipoComprobante != null) {
            this.cComplemento.setVisible(((String)tipoComprobante.getValor()).equals("04") || ((String)tipoComprobante.getValor()).equals("05"));
            if (this.modeloDatos.getComprobanteModificado().getTipoComprobante() != null) {
                String codComprobanteModif = this.modeloDatos.getComprobanteModificado().getTipoComprobante();
                ElementoNombreValor tipoAdicional = this.modeloValores.obtenerTipoComprobanteAdicional(codComprobanteModif);
                AyudanteViewer.seleccionarElemento((Viewer)this.cvCompModificado, (Object)tipoAdicional);
            }
        } else {
            this.cComplemento.setVisible(false);
        }
        ContextoValidacion ctxVal = new ContextoValidacion().agregar(InfoPantallas.COMPRA_COMPROBANTE.toString(), (Object)InfoPantallas.COMPRA_COMPROBANTE);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, ctxVal, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getComprobanteCompra().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getComprobanteModificado().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.marginWidth = 0;
        container.setLayout((Layout)gl_container);
        Label lblSustentoTributario = new Label(container, 0);
        GridData gd_lblSustentoTributario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblSustentoTributario.widthHint = 130;
        lblSustentoTributario.setLayoutData((Object)gd_lblSustentoTributario);
        lblSustentoTributario.setText("Sustento Tributario");
        this.cvSustento = new ComboViewer(container, 8);
        this.cvSustento.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor sustento = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (sustento != null) {
                    PaginaComprobanteCompra.this.modeloValores.cargarComprobantes((String)sustento.getValor(), sustento.getNombre(), PaginaComprobanteCompra.this.modeloDatos.getProveedor().getTipoIdentificacion());
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setTipoSustento((String)sustento.getValor());
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setDescripcionTipoSustento(sustento.getNombre());
                    PaginaComprobanteCompra.this.cvTipoComprobante.refresh();
                }
            }
        });
        Combo combo = this.cvSustento.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTipoComprobante = new Label(container, 0);
        GridData gd_lblTipoComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoComprobante.widthHint = 130;
        lblTipoComprobante.setLayoutData((Object)gd_lblTipoComprobante);
        lblTipoComprobante.setText("Tipo Comprobante");
        this.cvTipoComprobante = new ComboViewer(container, 8);
        this.cvTipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor comprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (comprobante != null) {
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setTipoComprobante((String)comprobante.getValor());
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setDescripcionTipoComprobante(comprobante.getNombre());
                    PaginaComprobanteCompra.this.cComplemento.setVisible(((String)comprobante.getValor()).equals("04") || ((String)comprobante.getValor()).equals("05"));
                    if (PaginaComprobanteCompra.this.editando && PaginaComprobanteCompra.this.cComplemento.isVisible()) {
                        PaginaComprobanteCompra.this.modeloDatos.getComprobanteModificado().reestablecer();
                        AyudanteViewer.seleccionarElemento((Viewer)PaginaComprobanteCompra.this.cvCompModificado, null);
                    }
                }
            }
        });
        Combo combo_1 = this.cvTipoComprobante.getCombo();
        GridData gd_combo_1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 425;
        combo_1.setLayoutData((Object)gd_combo_1);
        Label lblFechaEmisin = new Label(container, 0);
        lblFechaEmisin.setText("Fecha Emisi\u00f3n");
        final CDateTime dtFechaEmision = new CDateTime(container, 32771);
        dtFechaEmision.setNullText("seleccione la fecha");
        GridData gd_dtFechaEmision = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dtFechaEmision.widthHint = 125;
        dtFechaEmision.setLayoutData((Object)gd_dtFechaEmision);
        dtFechaEmision.setSelection(this.modeloDatos.getComprobanteCompra().getFechaEmision());
        dtFechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setFechaEmision(dtFechaEmision.getSelection());
            }
        });
        dtFechaEmision.setPattern("dd/MM/yyyy");
        Label lblFechaRegistro = new Label(container, 0);
        lblFechaRegistro.setText("Fecha Registro");
        final CDateTime dtFechaRegistro = new CDateTime(container, 32771);
        dtFechaRegistro.setNullText("seleccione la fecha");
        dtFechaRegistro.setPattern("dd/MM/yyyy");
        GridData gd_dtFechaRegistro = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dtFechaRegistro.widthHint = 125;
        dtFechaRegistro.setLayoutData((Object)gd_dtFechaRegistro);
        dtFechaRegistro.setSelection(this.modeloDatos.getComprobanteCompra().getFechaRegistro());
        dtFechaRegistro.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaComprobanteCompra.this.modeloDatos.getComprobanteCompra().setFechaRegistro(dtFechaRegistro.getSelection());
            }
        });
        new Label(container, 0);
        Composite composite = new Composite(container, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        Label label = new Label(composite, 0);
        label.setText("Establecimiento");
        Label label_1 = new Label(composite, 0);
        label_1.setText("Punto de Emisi\u00f3n");
        Label lblSecuencial = new Label(composite, 0);
        lblSecuencial.setText("Secuencial");
        this.txtEstablecimiento = new Text(composite, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        this.txtEstablecimiento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPuntoEmision = new Text(composite, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        this.txtPuntoEmision.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtNumSerie = new Text(composite, 2048);
        this.txtNumSerie.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtNumSerie.selectAll();
            }
        });
        this.txtNumSerie.setTextLimit(9);
        GridData gd_txtNumSerie = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtNumSerie.widthHint = 100;
        this.txtNumSerie.setLayoutData((Object)gd_txtNumSerie);
        Label lblNAutorizacion = new Label(container, 0);
        GridData gd_lblNAutorizacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNAutorizacion.widthHint = 130;
        lblNAutorizacion.setLayoutData((Object)gd_lblNAutorizacion);
        lblNAutorizacion.setText("N\u00b0 Autorizaci\u00f3n");
        this.txtNumAutorizacion = new Text(container, 2048);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtNumAutorizacion.selectAll();
            }
        });
        this.txtNumAutorizacion.setTextLimit(49);
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumAutorizacion.widthHint = 150;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        this.cComplemento = new Composite(container, 0);
        GridData gd_cComplemento = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_cComplemento.widthHint = 567;
        this.cComplemento.setLayoutData((Object)gd_cComplemento);
        GridLayout gl_cComplemento = new GridLayout(2, false);
        gl_cComplemento.marginWidth = 0;
        this.cComplemento.setLayout((Layout)gl_cComplemento);
        Label lblComplementoN = new Label(this.cComplemento, 0);
        lblComplementoN.setText("Complemento De N/C - ND");
        lblComplementoN.setFont(SWTResourceManager.getBoldFont((Font)lblComplementoN.getFont()));
        new Label(this.cComplemento, 0);
        Label lblDocumentoModificado = new Label(this.cComplemento, 0);
        GridData gd_lblDocumentoModificado = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblDocumentoModificado.widthHint = 125;
        lblDocumentoModificado.setLayoutData((Object)gd_lblDocumentoModificado);
        lblDocumentoModificado.setText("Documento Modificado");
        this.cvCompModificado = new ComboViewer(this.cComplemento, 8);
        this.cvCompModificado.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor comprobanteAdicional = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (comprobanteAdicional != null) {
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteModificado().setTipoComprobante((String)comprobanteAdicional.getValor());
                    PaginaComprobanteCompra.this.modeloDatos.getComprobanteModificado().setDescripcionTipoComprobante(comprobanteAdicional.getNombre());
                }
            }
        });
        Combo combo_2 = this.cvCompModificado.getCombo();
        combo_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Composite composite_1 = new Composite(this.cComplemento, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_composite_1 = new GridLayout(6, false);
        gl_composite_1.marginWidth = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        Label label_3 = new Label(composite_1, 0);
        GridData gd_label_3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_label_3.widthHint = 155;
        label_3.setLayoutData((Object)gd_label_3);
        label_3.setText("N\u00b0 Comprobante Modificado");
        this.txtEstabModif = new Text(composite_1, 2048);
        this.txtEstabModif.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtEstabModif.selectAll();
            }
        });
        this.txtEstabModif.setTextLimit(3);
        GridData gd_txtEstabModif = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtEstabModif.widthHint = 65;
        this.txtEstabModif.setLayoutData((Object)gd_txtEstabModif);
        this.txtPuntoMod = new Text(composite_1, 2048);
        this.txtPuntoMod.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtPuntoMod.selectAll();
            }
        });
        this.txtPuntoMod.setTextLimit(3);
        GridData gd_txtPuntoMod = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtPuntoMod.widthHint = 65;
        this.txtPuntoMod.setLayoutData((Object)gd_txtPuntoMod);
        this.txtSerialMod = new Text(composite_1, 2048);
        this.txtSerialMod.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtSerialMod.selectAll();
            }
        });
        this.txtSerialMod.setTextLimit(9);
        GridData gd_txtSerialMod = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtSerialMod.widthHint = 65;
        this.txtSerialMod.setLayoutData((Object)gd_txtSerialMod);
        Label label_4 = new Label(composite_1, 0);
        label_4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_4.setText("Autorizaci\u00f3n");
        this.txtAutModif = new Text(composite_1, 2048);
        this.txtAutModif.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobanteCompra.this.txtAutModif.selectAll();
            }
        });
        this.txtAutModif.setTextLimit(49);
        GridData gd_txtAutModif = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtAutModif.widthHint = 80;
        this.txtAutModif.setLayoutData((Object)gd_txtAutModif);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue establecimientoModeloDatosObserveValue = BeanProperties.value((String)"comprobanteCompra.establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, establecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue puntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteCompra.puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, puntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumSerieObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumSerie);
        IObservableValue secuencialModeloDatosObserveValue = BeanProperties.value((String)"comprobanteCompra.secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumSerieObserveWidget, secuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue numAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteCompra.numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, numAutorizacionModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvSustento.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvSustento.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tipoSustentoModeloValoresObserveList = PojoProperties.list((String)"tipoSustento").observe((Object)this.modeloValores);
        this.cvSustento.setInput((Object)tipoSustentoModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvTipoComprobante.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList tipoComprobanteModeloValoresObserveList = PojoProperties.list((String)"tipoComprobante").observe((Object)this.modeloValores);
        this.cvTipoComprobante.setInput((Object)tipoComprobanteModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvCompModificado.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvCompModificado.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList tiposComprobantesAdicionalModeloValoresObserveList = PojoProperties.list((String)"tiposComprobantesAdicional").observe((Object)this.modeloValores);
        this.cvCompModificado.setInput((Object)tiposComprobantesAdicionalModeloValoresObserveList);
        ISWTObservableValue observeTextTxtEstabModifObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstabModif);
        IObservableValue comprobanteModificadoestablecimientoModeloDatosObserveValue = BeanProperties.value((String)"comprobanteModificado.establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstabModifObserveWidget, comprobanteModificadoestablecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoModObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoMod);
        IObservableValue comprobanteModificadopuntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteModificado.puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoModObserveWidget, comprobanteModificadopuntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSerialModObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSerialMod);
        IObservableValue comprobanteModificadosecuencialModeloDatosObserveValue = BeanProperties.value((String)"comprobanteModificado.secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSerialModObserveWidget, comprobanteModificadosecuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtAutModifObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtAutModif);
        IObservableValue comprobanteModificadonumAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteModificado.numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtAutModifObserveWidget, comprobanteModificadonumAutorizacionModeloDatosObserveValue, null, null);
        return bindingContext;
    }
}

